/*  Änderungen an KSVBA-Ressourcen in die Ausschaltzeiten übertragen. */
CREATE OR REPLACE FUNCTION scheduling.sync__resource__resource_timeline() RETURNS trigger AS $$
    BEGIN

        IF ( TG_OP = 'DELETE' ) THEN

            IF
                EXISTS(
                    SELECT true
                    FROM scheduling.resource_timeline
                    WHERE
                        ti_resource_id = old.id
                    AND ti_type IN ( 'task', 'task.buffer', 'task.blocktime' )
                )
            THEN
                RAISE EXCEPTION 'Fehler: Ressource % kann nicht gelöscht werden! Es sind noch AGs auf der Ressource eingeplant.', old.id;
            END IF;

            -- Debug
            PERFORM LogDebugVerbose( message => format( 'delete offtimes, because connected resource %s should be deleted;', old.id ) );

            DELETE FROM scheduling.resource_timeline
            WHERE
                ti_resource_id = old.id
            AND ti_type IN ( 'off', 'off.day', 'off.time' );

            RETURN old;

        ELSIF ( TG_OP = 'INSERT' ) THEN

            -- Debug
            PERFORM LogDebugVerbose( message => format( 'renew offtimes, because connected resource %s was inserted;', new.id ) );

            -- ... Ausschaltzeiten (neu) schreiben.
            PERFORM scheduling.resource_timeline__renew_offtime( _resource_id => new.id );

            RETURN new;

        -- Update
        ELSE

            -- Debug
            PERFORM LogDebugVerbose( message => format( 'renew offtimes, because for connected resource %s number of machines was changed %s -> %s;', new.id, old.ta_fk, new.ta_fk ) );

            -- ... Ausschaltzeiten (neu) schreiben.
            PERFORM scheduling.resource_timeline__renew_offtime( _resource_id => new.id );

            RETURN new;

        END IF;

  END $$ language plpgsql;

DROP TRIGGER IF EXISTS resource_005_sync_resource_timeline_a__i ON scheduling.resource;
DROP TRIGGER IF EXISTS resource_005_sync_resource_timeline_a__iu ON scheduling.resource;
CREATE TRIGGER resource_005_sync_resource_timeline_a__iu
    AFTER INSERT
        OR UPDATE OF ta_fk
    ON scheduling.resource
    FOR EACH ROW
    WHEN (new.context = 'ksvba')
    EXECUTE PROCEDURE scheduling.sync__resource__resource_timeline();

DROP TRIGGER IF EXISTS resource_005_sync_resource_timeline_b__d ON scheduling.resource;
CREATE TRIGGER resource_005_sync_resource_timeline_b__d
    BEFORE DELETE
    ON scheduling.resource
    FOR EACH ROW
    WHEN (old.context = 'ksvba')
    EXECUTE PROCEDURE scheduling.sync__resource__resource_timeline();
--